
/************************************************************
 *																				*
 *								STRIPTCR.C									*
 *																				*
 *		Utility to convert CR/LF pairs to LF only.				*
 *		This is an MSDOS utility to convert source files		*
 *		for UNIX systems.													*
 *																				*
 ************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#define	BFR_SIZE	512
#define	CR			0x0d

FILE	*fpi;
FILE	*fpo;
char	bfr_in[BFR_SIZE];
char	bfr_out[BFR_SIZE];

main(int argc, char *argv[])
{
	int	i, j, k;

	if(argc < 3)
	{
		printf("\nUsage: stripcr file.in file.out\n");
		exit(1);
	}
	fpi = fopen(argv[1], "rb");
	if (fpi == NULL)
	{
		printf("Can't open '%s'\n", argv[1]);
		exit(1);
	}
	fpo = fopen(argv[2], "wb");
	if (fpi == NULL)
	{
		printf("Can't open '%s'\n", argv[2]);
		exit(1);
	}
	i = 1;
	while (i)
	{
		i = fread(bfr_in, 1, 256, fpi);
		for (j=0, k=0; j<i; j++)
		{
			if (bfr_in[j] != CR)
				bfr_out[k++] = bfr_in[j];
		}
		if (k)
			fwrite(bfr_out, 1, k, fpo);
	}
	fclose(fpi);
	fflush(fpo);
	fclose(fpo);
}

/* end of stripcr.c */

